(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    154360,       3308]
NotebookOptionsPosition[     98184,       2019]
NotebookOutlinePosition[    152994,       3275]
CellTagsIndexPosition[    152951,       3272]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Load the data file (add the file path if necessary):", "MyStyle - H3",
 CellChangeTimes->{{3.739471538482309*^9, 3.73947156622493*^9}, {
  3.739472595593813*^9, 
  3.7394726176736245`*^9}},ExpressionUUID->"48440d69-55fe-498e-9c8c-\
38c901e9aafb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<dataFile\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.7394715470752335`*^9, 
  3.7394715517464857`*^9}},ExpressionUUID->"d21748be-f06a-4239-a8ec-\
fd8c77fd3cd1"],

Cell["\<\
The available variables are:
allTopologies,renormalizableTopologies,noTadpoleTopologies,\
noSelfEnergyTopologies,onePITopologies,normalGenuineTopologies,\
specialGenuineTopologies,nonGenuineFiniteTopologies,\
nonGenuineInfiniteTopologies,normalGenuineDiagrams,specialGenuineDiagrams,\
normalGenuineAmpDiagrams, and specialGenuineAmpDiagrams

Topologies can be plotted with the function AdjacencyGraph, while diagrams \
can be plotted with the function PaintLabelledDiagram\
\>", "MyStyle - H3",
 CellChangeTimes->{{3.739471538482309*^9, 3.739471705442881*^9}, 
   3.7394720064990067`*^9, {3.746272024643429*^9, 
   3.7462720520547037`*^9}},ExpressionUUID->"73a88ba1-f430-42c3-bf87-\
0970f7e004c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Number", " ", "of", " ", 
    RowBox[{"topologies", "/", "diagrams"}], " ", "in", " ", "each", " ", 
    "variable"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Length", "/@", 
   RowBox[{"{", 
    RowBox[{
    "allTopologies", ",", "renormalizableTopologies", ",", 
     "noTadpoleTopologies", ",", "noSelfEnergyTopologies", ",", 
     "onePITopologies", ",", "normalGenuineTopologies", ",", 
     "specialGenuineTopologies", ",", "nonGenuineFiniteTopologies", ",", 
     "nonGenuineInfiniteTopologies", ",", "normalGenuineDiagrams", ",", 
     "specialGenuineDiagrams", ",", "normalGenuineAmpDiagrams", ",", 
     "specialGenuineAmpDiagrams"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.739472038969073*^9, 3.7394720734412613`*^9}, 
   3.7462720272451634`*^9},ExpressionUUID->"a410d0bd-fb4a-4898-8eeb-\
e4a9c8290e99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4367", ",", "3269", ",", "1056", ",", "370", ",", "160", ",", "44", ",", 
   "55", ",", "9", ",", "52", ",", "228", ",", "271", ",", "18", ",", "20"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.739472073983597*^9, 3.739472179839118*^9, 3.7462720302411604`*^9, 
   3.746272227311037*^9, 3.762067177007423*^9, 3.762067491329387*^9, 
   3.762067524179538*^9, {3.762173623505348*^9, 
   3.76217363180416*^9}},ExpressionUUID->"1992921e-feef-4168-8632-\
db5d4f9b4b4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "A", " ", "topology", " ", "is", " ", "given", " ", "by", " ", "an", " ", 
    "adjacency", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"onePITopologies", "[", 
    RowBox[{"[", "90", "]"}], "]"}], "//", "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.7394720850877047`*^9, 3.7394721091513586`*^9}, 
   3.7394723120927224`*^9},ExpressionUUID->"8a1ee9dd-3108-4a8b-a9c8-\
f700b260f862"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "1", "0", "2", "0", "0", "0", "0"},
     {"1", "0", "1", "0", "0", "1", "0", "0", "0"},
     {"1", "1", "0", "0", "0", "0", "1", "0", "0"},
     {"0", "0", "0", "0", "2", "0", "0", "1", "1"},
     {"2", "0", "0", "2", "0", "0", "0", "0", "0"},
     {"0", "1", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "1", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "1", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.739472110330654*^9, 3.739472182346404*^9, 
  3.7394723129334507`*^9, 3.7462720555400257`*^9, 3.7462722274060993`*^9, 
  3.7620672016834984`*^9, 3.762067493038863*^9, 3.7620675263986096`*^9, 
  3.7621736572261887`*^9},ExpressionUUID->"35207b7a-0c05-4eee-886a-\
1f96a2481949"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "A", " ", "diagram", " ", "is", " ", "given", " ", "by", " ", "a", " ", 
     "matrix", " ", "D"}], ",", 
    RowBox[{
     RowBox[{"here", " ", 
      RowBox[{"D", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "is", " ", "a", " ", 
      "list", " ", "indicating", " ", "what", " ", "is", " ", "connecting", 
      " ", "vertex", " ", "i", " ", "to", " ", "vertex", " ", "j", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "\"\<F\>\"", " ", "stands", " ", "for", " ", "a", " ", "fermion", " ",
          "and", " ", "an", " ", "\"\<S\>\"", " ", "represents", " ", "a", 
         " ", "scalar"}], ")"}], ".", " ", "For"}], " ", "example", " ", 
      RowBox[{"D", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "=", 
     RowBox[{
      RowBox[{"{", "}"}], " ", "would", " ", "mean", " ", "that", " ", "the", 
      " ", "two", " ", "vertices", " ", 
      RowBox[{"(", 
       RowBox[{"i", " ", "and", " ", "j"}], ")"}], " ", "are", " ", "not", 
      " ", "connected"}]}], ",", " ", 
    RowBox[{
     RowBox[{"{", "\"\<S\>\"", "}"}], " ", "would", " ", "mean", " ", "that", 
     " ", "they", " ", "are", " ", "connected", " ", "by", " ", "a", " ", 
     "scalar"}], ",", 
    RowBox[{"and", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<S\>\"", ",", "\"\<F\>\""}], "}"}], " ", "implies", " ", 
     "that", " ", "a", " ", "scalar", " ", "and", " ", "a", " ", "fermion", 
     " ", "connect", " ", 
     RowBox[{"them", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"normalGenuineDiagrams", "[", 
    RowBox[{"[", "25", "]"}], "]"}], "//", "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.739472186333584*^9, 
  3.7394723076606836`*^9}},ExpressionUUID->"e8823691-3b7b-4447-9ab6-\
eda9ce39006c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "\<\"F\"\>", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.7394722906077127`*^9, 3.739472308127918*^9}, 
   3.7462720577885256`*^9, 3.746272231730982*^9, 3.762067204637607*^9, 
   3.7620674958732576`*^9, 3.76206752924203*^9, 
   3.762173659785378*^9},ExpressionUUID->"b49d5f9a-db17-406d-a6f6-\
2ae214773003"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Display", " ", "the", " ", "first", " ", "10", " ", "topologies", " ", 
    "in", " ", "allTopologies"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"AdjacencyGraph", "/@", 
   RowBox[{"allTopologies", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "10"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.739471713768901*^9, 
  3.7394717593733397`*^9}},ExpressionUUID->"f119bf84-8f6e-49ba-9d55-\
883a441a781a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {Null, 
         SparseArray[
         Automatic, {8, 8}, 0, {
          1, {{0, 4, 8, 12, 16, 17, 18, 19, 20}, {{2}, {3}, {4}, {5}, {1}, {
            3}, {4}, {6}, {1}, {2}, {4}, {7}, {1}, {2}, {3}, {8}, {1}, {2}, {
            3}, {4}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{0.8017467907915568, 1.598864643160119}, {
         1.5990433111158853`, 1.619387202396285}, {0.8213079218270726, 
         0.801311582752686}, {1.619267772300705, 0.8205850551482841}, {0., 
         2.3618670867279556`}, {2.361567483856092, 2.422907072130563}, {
         0.057184647053634574`, 0.}, {2.4216513327067046`, 
         0.05784224496045698}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{3, 4}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.025952891680612405`]}, 
           {Arrowheads[0.], ArrowBox[{4, 8}, 0.025952891680612405`]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.025952891680612405], DiskBox[2, 0.025952891680612405],
            DiskBox[3, 0.025952891680612405], 
           DiskBox[4, 0.025952891680612405], DiskBox[5, 0.025952891680612405],
            DiskBox[6, 0.025952891680612405], 
           DiskBox[7, 0.025952891680612405], 
           DiskBox[8, 0.025952891680612405]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {3}, {4}, {5}, {1}, {2}, {6}, {7}, {1}, {2}, {8}, {1}, {2}, {
            9}, {3}, {3}, {4}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{1.9811124020821111`, 1.751154899190801}, {
         1.9805553238194282`, 1.3812697401671756`}, {0.889318540096017, 
         1.5662988822189685`}, {2.6179898002435285`, 2.3198543798825377`}, {
         2.615953285197566, 0.8105588231313192}, {0., 1.0065807879369242`}, {
         0.0017477347314793779`, 2.126755601857865}, {3.2757217120364484`, 
         3.1281050119024654`}, {3.2713409055478833`, 0.}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{2, 5}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{3, 6}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{4, 8}, 0.03218468505041984]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.03218468505041984]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03218468505041984], DiskBox[2, 0.03218468505041984], 
           DiskBox[3, 0.03218468505041984], DiskBox[4, 0.03218468505041984], 
           DiskBox[5, 0.03218468505041984], DiskBox[6, 0.03218468505041984], 
           DiskBox[7, 0.03218468505041984], DiskBox[8, 0.03218468505041984], 
           DiskBox[9, 0.03218468505041984]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {3}, {4}, {6}, {1}, {2}, {4}, {7}, {1}, {2}, {3}, {1}, {8}, {
            9}, {2}, {3}, {5}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.2585515436693515`, 1.2574029748111073`}, {
         3.2962461764133906`, 1.7283264917445809`}, {3.2970303877126703`, 
         0.7868620027586737}, {2.9055449207298882`, 1.2570818926480984`}, {
         0.8425469632560785, 1.2573998242044997`}, {4.016320685210255, 
         2.5160251294358904`}, {4.01794532133492, 0.}, {0., 
         1.8252445144883467`}, {0.00007301697058048617, 0.6894915667573216}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{3, 4}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{5, 8}, 0.0371200941346333]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.0371200941346333]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.0371200941346333], DiskBox[2, 0.0371200941346333], 
           DiskBox[3, 0.0371200941346333], DiskBox[4, 0.0371200941346333], 
           DiskBox[5, 0.0371200941346333], DiskBox[6, 0.0371200941346333], 
           DiskBox[7, 0.0371200941346333], DiskBox[8, 0.0371200941346333], 
           DiskBox[9, 0.0371200941346333]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {3}, {4}, {6}, {1}, {2}, {5}, {7}, {1}, {2}, {8}, {1}, {3}, {
            9}, {2}, {3}, {4}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.1121608565925136`, 1.3228393320596992`}, {
         2.612651210759468, 1.695543594908068}, {1.6131095824403403`, 
         0.9507804433272362}, {3.243645879957279, 1.1006950183016064`}, {
         0.9813043103295718, 1.5426028692984421`}, {3.11086026644064, 
         2.6468411441502133`}, {1.1140442360823593`, 0.}, {4.224279729160536, 
         0.7245703553471825}, {0., 1.915290307520976}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{3, 5}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{4, 8}, 0.03841950526211364]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.03841950526211364]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03841950526211364], DiskBox[2, 0.03841950526211364], 
           DiskBox[3, 0.03841950526211364], DiskBox[4, 0.03841950526211364], 
           DiskBox[5, 0.03841950526211364], DiskBox[6, 0.03841950526211364], 
           DiskBox[7, 0.03841950526211364], DiskBox[8, 0.03841950526211364], 
           DiskBox[9, 0.03841950526211364]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {3}, {4}, {6}, {1}, {2}, {7}, {8}, {1}, {2}, {5}, {1}, {4}, {
            9}, {2}, {3}, {3}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.1196838012577777`, 1.0048130332429235`}, {
         2.5594676471265156`, 1.7075424297680737`}, {3.269470115922056, 
         0.8824068835710286}, {1.6132169265303056`, 1.4639029464356625`}, {
         0.9839122382266188, 0.8873976987927559}, {2.7812532482310424`, 
         2.7366381679806047`}, {4.309675748440127, 0.9863393079639817}, {
         3.8222967867218918`, 0.}, {0., 0.5988678663011517}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{4, 5}, 0.03894858364269961]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.03894858364269961]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03894858364269961], DiskBox[2, 0.03894858364269961], 
           DiskBox[3, 0.03894858364269961], DiskBox[4, 0.03894858364269961], 
           DiskBox[5, 0.03894858364269961], DiskBox[6, 0.03894858364269961], 
           DiskBox[7, 0.03894858364269961], DiskBox[8, 0.03894858364269961], 
           DiskBox[9, 0.03894858364269961]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {4}, {5}, {6}, {1}, {4}, {7}, {8}, {1}, {2}, {3}, {1}, {2}, {
            9}, {2}, {3}, {3}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.15050886283368, 0.9075212158864018}, {
         2.807348325015107, 1.4835001809467823`}, {0.9354677816845083, 
         1.0005288903361276`}, {1.799780539484847, 1.4382784544975968`}, {
         3.189746397683577, 0.6112591254216273}, {3.4807989306492173`, 
         2.2884080751316933`}, {0.1371793296624122, 0.3417278512425126}, {0., 
         1.4548988565617242`}, {4.019516331888599, 0.}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{2, 5}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{3, 4}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.03713010205584803]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.03713010205584803]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03713010205584803], DiskBox[2, 0.03713010205584803], 
           DiskBox[3, 0.03713010205584803], DiskBox[4, 0.03713010205584803], 
           DiskBox[5, 0.03713010205584803], DiskBox[6, 0.03713010205584803], 
           DiskBox[7, 0.03713010205584803], DiskBox[8, 0.03713010205584803], 
           DiskBox[9, 0.03713010205584803]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {4}, {5}, {6}, {1}, {7}, {8}, {9}, {1}, {2}, {5}, {1}, {2}, {
            4}, {2}, {3}, {3}, {3}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.352388928313534, 0.8934468074012035}, {
         1.0753260557191193`, 0.8934316121263823}, {3.860866995206872, 
         0.8933790559664324}, {1.6302217968982444`, 0.5360014131116644}, {
         1.6303357253089503`, 1.250926395690568}, {0., 0.8932474530022999}, {
         4.368357634090421, 1.7867062022778215`}, {4.368244311067597, 0.}, {
         4.9309480521958715`, 0.893324949604593}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{2, 5}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{3, 7}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{3, 9}, 0.04265173224696543]}, 
           {Arrowheads[0.], ArrowBox[{4, 5}, 0.04265173224696543]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.04265173224696543], DiskBox[2, 0.04265173224696543], 
           DiskBox[3, 0.04265173224696543], DiskBox[4, 0.04265173224696543], 
           DiskBox[5, 0.04265173224696543], DiskBox[6, 0.04265173224696543], 
           DiskBox[7, 0.04265173224696543], DiskBox[8, 0.04265173224696543], 
           DiskBox[9, 0.04265173224696543]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {5}, {
            1}, {4}, {6}, {7}, {1}, {5}, {8}, {9}, {1}, {2}, {5}, {1}, {3}, {
            4}, {2}, {2}, {3}, {3}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.2174392785388264`, 0.6496637372726812}, {
         3.489246703585322, 0.6765359662520414}, {0.9443478798052207, 
         0.6764161557662773}, {2.6872124728149247`, 1.1053234458241288`}, {
         1.7458901365216184`, 1.105096340176259}, {4.433455973234412, 
         1.1310599468698213`}, {4.280280105146103, 0.0012741050723981129`}, {
         0., 1.1322496006883203`}, {0.1532583087929802, 0.}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{2, 7}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{3, 5}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{3, 9}, 0.03970662829236374]}, 
           {Arrowheads[0.], ArrowBox[{4, 5}, 0.03970662829236374]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03970662829236374], DiskBox[2, 0.03970662829236374], 
           DiskBox[3, 0.03970662829236374], DiskBox[4, 0.03970662829236374], 
           DiskBox[5, 0.03970662829236374], DiskBox[6, 0.03970662829236374], 
           DiskBox[7, 0.03970662829236374], DiskBox[8, 0.03970662829236374], 
           DiskBox[9, 0.03970662829236374]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {6}, {
            1}, {3}, {4}, {7}, {1}, {2}, {5}, {8}, {1}, {2}, {5}, {3}, {4}, {
            9}, {1}, {2}, {3}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{2.687056200362293, 0.8518656149362418}, {
         2.797512382755177, 1.602201994985914}, {1.903733880391681, 
         1.7153795153906453`}, {1.9805812799782445`, 0.9718553292293907}, {
         1.0059441117421652`, 1.1189486181273112`}, {3.342824725816327, 0.}, {
         3.7165408686263177`, 2.1545663048029806`}, {1.5208028695620357`, 
         2.717319296195223}, {0., 0.8460066088860437}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{1, 6}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{2, 7}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{3, 5}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{4, 5}, 0.035166634690201565`]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.035166634690201565`]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.035166634690201565], DiskBox[2, 0.035166634690201565],
            DiskBox[3, 0.035166634690201565], 
           DiskBox[4, 0.035166634690201565], DiskBox[5, 0.035166634690201565],
            DiskBox[6, 0.035166634690201565], 
           DiskBox[7, 0.035166634690201565], DiskBox[8, 0.035166634690201565],
            DiskBox[9, 0.035166634690201565]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
         SparseArray[
         Automatic, {9, 9}, 0, {
          1, {{0, 4, 8, 12, 15, 18, 19, 20, 21, 22}, {{2}, {3}, {4}, {6}, {
            1}, {4}, {5}, {7}, {1}, {4}, {5}, {8}, {1}, {2}, {3}, {2}, {3}, {
            9}, {1}, {2}, {3}, {5}}}, Pattern}]}]]}, 
      TagBox[
       GraphicsGroupBox[
        GraphicsComplexBox[{{1.0732751857855667`, 1.761995356734083}, {
         1.9427657000292051`, 1.069036944663994}, {1.9480121338888348`, 
         2.4518271014180644`}, {1.6622741147530302`, 1.761870266958562}, {
         2.8250950439655047`, 1.7568225066829055`}, {0., 
         1.7632000118587967`}, {1.9886116699140284`, 0.}, {2.001902269031129, 
         3.5208913895043317`}, {3.880041710867342, 1.7518706522567888`}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{1, 6}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{2, 5}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{2, 7}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{3, 4}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{3, 5}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{3, 8}, 0.036234627147461604`]}, 
           {Arrowheads[0.], ArrowBox[{5, 9}, 0.036234627147461604`]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.036234627147461604], DiskBox[2, 0.036234627147461604],
            DiskBox[3, 0.036234627147461604], 
           DiskBox[4, 0.036234627147461604], DiskBox[5, 0.036234627147461604],
            DiskBox[6, 0.036234627147461604], 
           DiskBox[7, 0.036234627147461604], DiskBox[8, 0.036234627147461604],
            DiskBox[9, 0.036234627147461604]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None]}], "}"}]], "Output",
 CellChangeTimes->{{3.7394717522066307`*^9, 3.739471760105483*^9}, 
   3.7394720123116565`*^9, 3.7462720634152765`*^9, 3.7462722384424567`*^9, 
   3.762067213236555*^9, 3.7620675002106204`*^9, 3.7620675331914415`*^9, 
   3.762173663669961*^9},ExpressionUUID->"38d18808-2c1c-4477-8ca9-\
67ed45f46bb4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Display", " ", "the", " ", "first", " ", "10", " ", "diagrams", " ", "in",
     " ", "specialGenuineDiagrams"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"PaintLabelledDiagram", "/@", 
   RowBox[{"specialGenuineDiagrams", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "10"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7394717705903473`*^9, 3.7394717789450197`*^9}, 
   3.739472015898863*^9},ExpressionUUID->"1ff543ce-7bb8-454e-aa5e-\
a16e83956cd7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {4, 10}, {6, 
         9}, {6, 11}, {8, 10}, {8, 11}, {9, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 10] -> ({Increment[$CellContext`x9$1968]; Append[
               Part[{{}}, $CellContext`x9$1968], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x6$1968]; Append[
               Part[{{}}, $CellContext`x6$1968], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x4$1968]; Append[
               Part[{{}}, $CellContext`x4$1968], 
               Line[#]]}& ), 
           UndirectedEdge[5, 6] -> ({Increment[$CellContext`x7$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x7$1968], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x3$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x3$1968], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x10$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x10$1968], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x12$1968]; Append[
               Part[{{}}, $CellContext`x12$1968], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x11$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x11$1968], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x13$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x13$1968], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x5$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x5$1968], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x15$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x15$1968], 
               Line[#]]}& ), 
           UndirectedEdge[9, 11] -> ({Increment[$CellContext`x14$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x14$1968], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x8$1968]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x8$1968], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.005258518991861916, 2.8080125740794353`}, {
            0.7918627505126585, 2.2334807220176627`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.7918627505126585, 2.2334807220176627`}, {
            0.7899633174822058, 1.1803431074973183`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.7918627505126585, 2.2334807220176627`}, {
            1.9086048773570332`, 2.404975021076388}}]}, 
          LineBox[{{0., 0.6073377344304847}, {0.7899633174822058, 
           1.1803431074973183`}}], 
          LineBox[{{0.7899633174822058, 1.1803431074973183`}, {
           1.9058659423184596`, 1.0068469523489778`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.4579242272456687`, 3.4033298897416344`}, {
            2.806493163245209, 2.6802316913347006`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.806493163245209, 2.6802316913347006`}, {
            1.9086048773570332`, 2.404975021076388}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.806493163245209, 2.6802316913347006`}, {
            2.5056213103042353`, 1.7049324253033487`}}]}, 
          LineBox[{{3.449829163133555, 0.}, {2.802112174301148, 
           0.7274960141333913}}], 
          LineBox[{{2.802112174301148, 0.7274960141333913}, {
           1.9058659423184596`, 1.0068469523489778`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.802112174301148, 0.7274960141333913}, {
            2.5056213103042353`, 1.7049324253033487`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9086048773570332`, 2.404975021076388}, {
            2.5056213103042353`, 1.7049324253033487`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9058659423184596`, 1.0068469523489778`}, {
            2.5056213103042353`, 1.7049324253033487`}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0.005258518991861916, 2.8080125740794353}, 
           0.03343578316868133], 
          DiskBox[{0.7918627505126585, 2.2334807220176627}, 
           0.03343578316868133], 
          DiskBox[{0., 0.6073377344304847}, 0.03343578316868133], 
          DiskBox[{0.7899633174822058, 1.1803431074973183}, 
           0.03343578316868133], 
          DiskBox[{3.4579242272456687, 3.4033298897416344}, 
           0.03343578316868133], 
          DiskBox[{2.806493163245209, 2.6802316913347006}, 
           0.03343578316868133], 
          DiskBox[{3.449829163133555, 0.}, 0.03343578316868133], 
          DiskBox[{2.802112174301148, 0.7274960141333913}, 
           0.03343578316868133], 
          DiskBox[{1.9086048773570332, 2.404975021076388}, 
           0.03343578316868133], 
          DiskBox[{1.9058659423184596, 1.0068469523489778}, 
           0.03343578316868133], 
          DiskBox[{2.5056213103042353, 1.7049324253033487}, 
           0.03343578316868133]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 6, 2, 5, 3, 7, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {4, 2}, {4, 9}, {2, 10}, {6, 
         9}, {6, 11}, {8, 10}, {8, 11}, {9, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 10] -> ({Increment[$CellContext`x22$1971]; Append[
               Part[{{}}, $CellContext`x22$1971], 
               Line[#]]}& ), 
           UndirectedEdge[1, 6] -> ({Increment[$CellContext`x16$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x16$1971], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x19$1971]; Append[
               Part[{{}}, $CellContext`x19$1971], 
               Line[#]]}& ), 
           UndirectedEdge[5, 6] -> ({Increment[$CellContext`x20$1971]; Append[
               Part[{{}}, $CellContext`x20$1971], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x23$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x23$1971], 
               Line[#]]}& ), 
           UndirectedEdge[2, 5] -> ({Increment[$CellContext`x17$1971]; Append[
               Part[{{}}, $CellContext`x17$1971], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x25$1971]; Append[
               Part[{{}}, $CellContext`x25$1971], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x24$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x24$1971], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x26$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x26$1971], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x18$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x18$1971], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x28$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x28$1971], 
               Line[#]]}& ), 
           UndirectedEdge[9, 11] -> ({Increment[$CellContext`x27$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x27$1971], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x21$1971]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x21$1971], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.00437009852380732, 0.591699794049362}, {
            0.7910818451824835, 1.1669756275751206`}}]}, 
          LineBox[{{0.7910818451824835, 1.1669756275751206`}, {
           0.7891481968356384, 2.220284150356655}}], 
          LineBox[{{0.7910818451824835, 1.1669756275751206`}, {
           1.9076021467724456`, 0.996526366933116}}], 
          LineBox[{{0., 2.794465633319727}, {0.7891481968356384, 
           2.220284150356655}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.7891481968356384, 2.220284150356655}, {
            1.9044121546650108`, 2.394415696197101}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.449832600882789, 3.3995240822247275`}, {
            2.801116072561962, 2.6731352387990364`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.801116072561962, 2.6731352387990364`}, {
            1.9044121546650108`, 2.394415696197101}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.801116072561962, 2.6731352387990364`}, {
            2.5044935811387314`, 1.6966205013409006`}}]}, 
          LineBox[{{3.460537170961771, 0.}, {2.806428176639983, 
           0.7222278147016757}}], 
          LineBox[{{2.806428176639983, 0.7222278147016757}, {
           1.9076021467724456`, 0.996526366933116}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.806428176639983, 0.7222278147016757}, {
            2.5044935811387314`, 1.6966205013409006`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9044121546650108`, 2.394415696197101}, {
            2.5044935811387314`, 1.6966205013409006`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9076021467724456`, 0.996526366933116}, {
            2.5044935811387314`, 1.6966205013409006`}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0.00437009852380732, 0.591699794049362}, 
           0.03345353178195941], 
          DiskBox[{0.7910818451824835, 1.1669756275751206}, 
           0.03345353178195941], 
          DiskBox[{0., 2.794465633319727}, 0.03345353178195941], 
          DiskBox[{0.7891481968356384, 2.220284150356655}, 
           0.03345353178195941], 
          DiskBox[{3.449832600882789, 3.3995240822247275}, 
           0.03345353178195941], 
          DiskBox[{2.801116072561962, 2.6731352387990364}, 
           0.03345353178195941], 
          DiskBox[{3.460537170961771, 0.}, 0.03345353178195941], 
          DiskBox[{2.806428176639983, 0.7222278147016757}, 
           0.03345353178195941], 
          DiskBox[{1.9044121546650108, 2.394415696197101}, 
           0.03345353178195941], 
          DiskBox[{1.9076021467724456, 0.996526366933116}, 
           0.03345353178195941], 
          DiskBox[{2.5044935811387314, 1.6966205013409006}, 
           0.03345353178195941]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 6}, {2, 9}, {4, 9}, {4, 
         10}, {6, 11}, {8, 10}, {8, 11}, {9, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 10] -> ({Increment[$CellContext`x36$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x36$1974], 
               Line[#]]}& ), 
           UndirectedEdge[6, 9] -> ({Increment[$CellContext`x35$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x35$1974], 
               Line[#]]}& ), 
           UndirectedEdge[5, 7] -> ({Increment[$CellContext`x33$1974]; Append[
               Part[{{}}, $CellContext`x33$1974], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x32$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x32$1974], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x30$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x30$1974], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x29$1974]; Append[
               Part[{{}}, $CellContext`x29$1974], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x38$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x38$1974], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x37$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x37$1974], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x39$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x39$1974], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x31$1974]; Append[
               Part[{{}}, $CellContext`x31$1974], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x41$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x41$1974], 
               Line[#]]}& ), 
           UndirectedEdge[9, 11] -> ({Increment[$CellContext`x40$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x40$1974], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x34$1974]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x34$1974], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{0., 2.1393944233743314`}, {0.8888281440157206, 
           1.731200107764716}}], 
          LineBox[{{0.8888281440157206, 1.731200107764716}, {
           1.2034531035341147`, 0.80921630260284}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8888281440157206, 1.731200107764716}, {
            1.9571847891475451`, 1.9237945368418798`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3807216909460003`, 3.2759550026120445`}, {
            2.8999573251593116`, 2.4238120166727275`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.8999573251593116`, 2.4238120166727275`}, {
            1.9571847891475451`, 1.9237945368418798`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.8999573251593116`, 2.4238120166727275`}, {
            3.1099158164289475`, 1.4614386114740676`}}]}, 
          LineBox[{{0.5494302025692208, 0.08149047273836452}, {
           1.2034531035341147`, 0.80921630260284}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{1.2034531035341147`, 0.80921630260284}, {
            2.3462534168864217`, 1.05098142486696}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{4.086470490659841, 0.}, {3.3413924702775324`, 
            0.6312654988201815}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3413924702775324`, 0.6312654988201815}, {
            3.1099158164289475`, 1.4614386114740676`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3413924702775324`, 0.6312654988201815}, {
            2.3462534168864217`, 1.05098142486696}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9571847891475451`, 1.9237945368418798`}, {
            2.3462534168864217`, 1.05098142486696}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.1099158164289475`, 1.4614386114740676`}, {
            2.3462534168864217`, 1.05098142486696}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0., 2.1393944233743314}, 0.03755498168957948], 
          DiskBox[{0.8888281440157206, 1.731200107764716}, 
           0.03755498168957948], 
          DiskBox[{3.3807216909460003, 3.2759550026120445}, 
           0.03755498168957948], 
          DiskBox[{2.8999573251593116, 2.4238120166727275}, 
           0.03755498168957948], 
          DiskBox[{0.5494302025692208, 0.08149047273836452}, 
           0.03755498168957948], 
          DiskBox[{1.2034531035341147, 0.80921630260284}, 
           0.03755498168957948], 
          DiskBox[{4.086470490659841, 0.}, 0.03755498168957948], 
          DiskBox[{3.3413924702775324, 0.6312654988201815}, 
           0.03755498168957948], 
          DiskBox[{1.9571847891475451, 1.9237945368418798}, 
           0.03755498168957948], 
          DiskBox[{3.1099158164289475, 1.4614386114740676}, 
           0.03755498168957948], 
          DiskBox[{2.3462534168864217, 1.05098142486696}, 
           0.03755498168957948]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 7, 3, 6, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {6, 9}, {6, 
         10}, {4, 11}, {8, 10}, {8, 11}, {9, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[3, 6] -> ({Increment[$CellContext`x44$1977]; Append[
               Part[{{}}, $CellContext`x44$1977], 
               Line[#]]}& ), 
           UndirectedEdge[6, 10] -> ({Increment[$CellContext`x49$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x49$1977], 
               Line[#]]}& ), 
           UndirectedEdge[6, 9] -> ({Increment[$CellContext`x48$1977]; Append[
               Part[{{}}, $CellContext`x48$1977], 
               Line[#]]}& ), 
           UndirectedEdge[5, 7] -> ({Increment[$CellContext`x46$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x46$1977], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x45$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x45$1977], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x42$1977]; Append[
               Part[{{}}, $CellContext`x42$1977], 
               Line[#]]}& ), 
           UndirectedEdge[2, 7] -> ({Increment[$CellContext`x43$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x43$1977], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x51$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x51$1977], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x50$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x50$1977], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x52$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x52$1977], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x54$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x54$1977], 
               Line[#]]}& ), 
           UndirectedEdge[9, 11] -> ({Increment[$CellContext`x53$1977]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x53$1977], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x47$1977]; Append[
               Part[{{}}, $CellContext`x47$1977], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{0., 0.4452142237737182}, {0.8248437193123077, 
           1.0233597510735422`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8248437193123077, 1.0233597510735422`}, {
            1.1183648073577088`, 1.5970060925819365`}}]}, 
          LineBox[{{0.8248437193123077, 1.0233597510735422`}, {
           1.8649074451249463`, 1.6789772028280814`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.27270843146898693`, 2.1749041939529374`}, {
            1.1183648073577088`, 1.5970060925819365`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.1183648073577088`, 1.5970060925819365`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          LineBox[{{3.3069224305356597`, 3.2179550879870784`}, {
           2.815388667017449, 2.3433063910939507`}}], 
          LineBox[{{2.815388667017449, 2.3433063910939507`}, {
           1.8649074451249463`, 1.6789772028280814`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.815388667017449, 2.3433063910939507`}, {
            3.121753377634751, 1.4637607420748653`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{4.080702051844841, 0.}, {3.3344390231074086`, 
            0.6545477553113637}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3344390231074086`, 0.6545477553113637}, {
            3.121753377634751, 1.4637607420748653`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3344390231074086`, 0.6545477553113637}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.8649074451249463`, 1.6789772028280814`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.121753377634751, 1.4637607420748653`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0., 0.4452142237737182}, 0.03751850212840782], 
          DiskBox[{0.8248437193123077, 1.0233597510735422}, 
           0.03751850212840782], 
          DiskBox[{0.27270843146898693, 2.1749041939529374}, 
           0.03751850212840782], 
          DiskBox[{1.1183648073577088, 1.5970060925819365}, 
           0.03751850212840782], 
          DiskBox[{3.3069224305356597, 3.2179550879870784}, 
           0.03751850212840782], 
          DiskBox[{2.815388667017449, 2.3433063910939507}, 
           0.03751850212840782], 
          DiskBox[{4.080702051844841, 0.}, 0.03751850212840782], 
          DiskBox[{3.3344390231074086, 0.6545477553113637}, 
           0.03751850212840782], 
          DiskBox[{1.8649074451249463, 1.6789772028280814}, 
           0.03751850212840782], 
          DiskBox[{3.121753377634751, 1.4637607420748653}, 
           0.03751850212840782], 
          DiskBox[{2.3325585871968526, 1.1754542288576229}, 
           0.03751850212840782]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 7, 3, 6, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {6, 9}, {6, 
         10}, {4, 11}, {8, 10}, {8, 11}, {9, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[3, 6] -> ({Increment[$CellContext`x57$1980]; Append[
               Part[{{}}, $CellContext`x57$1980], 
               Line[#]]}& ), 
           UndirectedEdge[6, 10] -> ({Increment[$CellContext`x62$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x62$1980], 
               Line[#]]}& ), 
           UndirectedEdge[6, 9] -> ({Increment[$CellContext`x61$1980]; Append[
               Part[{{}}, $CellContext`x61$1980], 
               Line[#]]}& ), 
           UndirectedEdge[5, 7] -> ({Increment[$CellContext`x59$1980]; Append[
               Part[{{}}, $CellContext`x59$1980], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x58$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x58$1980], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x55$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x55$1980], 
               Line[#]]}& ), 
           UndirectedEdge[2, 7] -> ({Increment[$CellContext`x56$1980]; Append[
               Part[{{}}, $CellContext`x56$1980], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x64$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x64$1980], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x63$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x63$1980], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x65$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x65$1980], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x67$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x67$1980], 
               Line[#]]}& ), 
           UndirectedEdge[9, 11] -> ({Increment[$CellContext`x66$1980]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x66$1980], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x60$1980]; Append[
               Part[{{}}, $CellContext`x60$1980], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.4452142237737182}, {0.8248437193123077, 
            1.0233597510735422`}}]}, 
          LineBox[{{0.8248437193123077, 1.0233597510735422`}, {
           1.1183648073577088`, 1.5970060925819365`}}], 
          LineBox[{{0.8248437193123077, 1.0233597510735422`}, {
           1.8649074451249463`, 1.6789772028280814`}}], 
          LineBox[{{0.27270843146898693`, 2.1749041939529374`}, {
           1.1183648073577088`, 1.5970060925819365`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{1.1183648073577088`, 1.5970060925819365`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          LineBox[{{3.3069224305356597`, 3.2179550879870784`}, {
           2.815388667017449, 2.3433063910939507`}}], 
          LineBox[{{2.815388667017449, 2.3433063910939507`}, {
           1.8649074451249463`, 1.6789772028280814`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.815388667017449, 2.3433063910939507`}, {
            3.121753377634751, 1.4637607420748653`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{4.080702051844841, 0.}, {3.3344390231074086`, 
            0.6545477553113637}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3344390231074086`, 0.6545477553113637}, {
            3.121753377634751, 1.4637607420748653`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.3344390231074086`, 0.6545477553113637}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.8649074451249463`, 1.6789772028280814`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.121753377634751, 1.4637607420748653`}, {
            2.3325585871968526`, 1.1754542288576229`}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0., 0.4452142237737182}, 0.03751850212840782], 
          DiskBox[{0.8248437193123077, 1.0233597510735422}, 
           0.03751850212840782], 
          DiskBox[{0.27270843146898693, 2.1749041939529374}, 
           0.03751850212840782], 
          DiskBox[{1.1183648073577088, 1.5970060925819365}, 
           0.03751850212840782], 
          DiskBox[{3.3069224305356597, 3.2179550879870784}, 
           0.03751850212840782], 
          DiskBox[{2.815388667017449, 2.3433063910939507}, 
           0.03751850212840782], 
          DiskBox[{4.080702051844841, 0.}, 0.03751850212840782], 
          DiskBox[{3.3344390231074086, 0.6545477553113637}, 
           0.03751850212840782], 
          DiskBox[{1.8649074451249463, 1.6789772028280814}, 
           0.03751850212840782], 
          DiskBox[{3.121753377634751, 1.4637607420748653}, 
           0.03751850212840782], 
          DiskBox[{2.3325585871968526, 1.1754542288576229}, 
           0.03751850212840782]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 11, 10}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {4, 10}, {6, 
         9}, {6, 10}, {8, 11}, {8, 10}, {9, 11}, {11, 10}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 11] -> ({Increment[$CellContext`x74$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x74$1983], 
               Line[#]]}& ), 
           UndirectedEdge[9, 10] -> ({Increment[$CellContext`x79$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x79$1983], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x71$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x71$1983], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x69$1983]; Append[
               Part[{{}}, $CellContext`x69$1983], 
               Line[#]]}& ), 
           UndirectedEdge[5, 6] -> ({Increment[$CellContext`x72$1983]; Append[
               Part[{{}}, $CellContext`x72$1983], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x68$1983]; Append[
               Part[{{}}, $CellContext`x68$1983], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x75$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x75$1983], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x77$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x77$1983], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x76$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x76$1983], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x78$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x78$1983], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x70$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x70$1983], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x80$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x80$1983], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x73$1983]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x73$1983], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{4.356757411264541, 0.}, {3.5776348824230384`, 
           0.6308070829891423}}], 
          LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
           3.2705692600095193`, 1.4476862871532192`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
            2.5608171535967394`, 1.056324582842535}}]}, 
          LineBox[{{4.130959373493924, 1.9939925918047017`}, {
           3.2705692600095193`, 1.4476862871532192`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.2705692600095193`, 1.4476862871532192`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.740347367311172, 3.0419214089378634`}, {
            2.048217304371548, 2.0790397033948085`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.048217304371548, 2.0790397033948085`}, {
            2.5608171535967394`, 1.056324582842535}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.048217304371548, 2.0790397033948085`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.38084977463297254`}, {0.9290981487070042, 
            0.7342210815652312}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5608171535967394`, 1.056324582842535}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9565324864619495`, 1.291463008970201}, {
            1.6961568721629507`, 0.6834434345517006}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{4.356757411264541, 0.}, 0.03923814201810573], 
          DiskBox[{3.5776348824230384, 0.6308070829891423}, 
           0.03923814201810573], 
          DiskBox[{4.130959373493924, 1.9939925918047017}, 
           0.03923814201810573], 
          DiskBox[{3.2705692600095193, 1.4476862871532192}, 
           0.03923814201810573], 
          DiskBox[{1.740347367311172, 3.0419214089378634}, 
           0.03923814201810573], 
          DiskBox[{2.048217304371548, 2.0790397033948085}, 
           0.03923814201810573], 
          DiskBox[{0., 0.38084977463297254}, 0.03923814201810573], 
          DiskBox[{0.9290981487070042, 0.7342210815652312}, 
           0.03923814201810573], 
          DiskBox[{2.5608171535967394, 1.056324582842535}, 
           0.03923814201810573], 
          DiskBox[{1.9565324864619495, 1.291463008970201}, 
           0.03923814201810573], 
          DiskBox[{1.6961568721629507, 0.6834434345517006}, 
           0.03923814201810573]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 11, 10}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {4, 10}, {6, 
         9}, {6, 10}, {8, 11}, {8, 10}, {9, 11}, {11, 10}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 11] -> ({Increment[$CellContext`x87$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x87$1986], 
               Line[#]]}& ), 
           UndirectedEdge[9, 10] -> ({Increment[$CellContext`x92$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x92$1986], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x84$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x84$1986], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x82$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x82$1986], 
               Line[#]]}& ), 
           UndirectedEdge[5, 6] -> ({Increment[$CellContext`x85$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x85$1986], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x81$1986]; Append[
               Part[{{}}, $CellContext`x81$1986], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x88$1986]; Append[
               Part[{{}}, $CellContext`x88$1986], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({Increment[$CellContext`x90$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x90$1986], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({Increment[$CellContext`x89$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x89$1986], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({Increment[$CellContext`x91$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x91$1986], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x83$1986]; Append[
               Part[{{}}, $CellContext`x83$1986], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x93$1986]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x93$1986], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x86$1986]; Append[
               Part[{{}}, $CellContext`x86$1986], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{4.356757411264541, 0.}, {3.5776348824230384`, 
           0.6308070829891423}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
            3.2705692600095193`, 1.4476862871532192`}}]}, 
          LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
           2.5608171535967394`, 1.056324582842535}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{4.130959373493924, 1.9939925918047017`}, {
            3.2705692600095193`, 1.4476862871532192`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.2705692600095193`, 1.4476862871532192`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          LineBox[{{1.740347367311172, 3.0419214089378634`}, {
           2.048217304371548, 2.0790397033948085`}}], 
          LineBox[{{2.048217304371548, 2.0790397033948085`}, {
           2.5608171535967394`, 1.056324582842535}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.048217304371548, 2.0790397033948085`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.38084977463297254`}, {0.9290981487070042, 
            0.7342210815652312}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5608171535967394`, 1.056324582842535}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9565324864619495`, 1.291463008970201}, {
            1.6961568721629507`, 0.6834434345517006}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{4.356757411264541, 0.}, 0.03923814201810573], 
          DiskBox[{3.5776348824230384, 0.6308070829891423}, 
           0.03923814201810573], 
          DiskBox[{4.130959373493924, 1.9939925918047017}, 
           0.03923814201810573], 
          DiskBox[{3.2705692600095193, 1.4476862871532192}, 
           0.03923814201810573], 
          DiskBox[{1.740347367311172, 3.0419214089378634}, 
           0.03923814201810573], 
          DiskBox[{2.048217304371548, 2.0790397033948085}, 
           0.03923814201810573], 
          DiskBox[{0., 0.38084977463297254}, 0.03923814201810573], 
          DiskBox[{0.9290981487070042, 0.7342210815652312}, 
           0.03923814201810573], 
          DiskBox[{2.5608171535967394, 1.056324582842535}, 
           0.03923814201810573], 
          DiskBox[{1.9565324864619495, 1.291463008970201}, 
           0.03923814201810573], 
          DiskBox[{1.6961568721629507, 0.6834434345517006}, 
           0.03923814201810573]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 11, 10}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 4}, {2, 9}, {4, 10}, {6, 
         9}, {6, 10}, {8, 11}, {8, 10}, {9, 11}, {11, 10}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 11] -> ({Increment[$CellContext`x100$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x100$1989], 
               Line[#]]}& ), 
           UndirectedEdge[9, 10] -> ({
            Increment[$CellContext`x105$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x105$1989], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x97$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x97$1989], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x95$1989]; Append[
               Part[{{}}, $CellContext`x95$1989], 
               Line[#]]}& ), 
           UndirectedEdge[5, 6] -> ({Increment[$CellContext`x98$1989]; Append[
               Part[{{}}, $CellContext`x98$1989], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x94$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x94$1989], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x101$1989]; Append[
               Part[{{}}, $CellContext`x101$1989], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({
            Increment[$CellContext`x103$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x103$1989], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({
            Increment[$CellContext`x102$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x102$1989], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({
            Increment[$CellContext`x104$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x104$1989], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x96$1989]; Append[
               Part[{{}}, $CellContext`x96$1989], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x106$1989]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x106$1989], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x99$1989]; Append[
               Part[{{}}, $CellContext`x99$1989], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{4.356757411264541, 0.}, {3.5776348824230384`, 
            0.6308070829891423}}]}, 
          LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
           3.2705692600095193`, 1.4476862871532192`}}], 
          LineBox[{{3.5776348824230384`, 0.6308070829891423}, {
           2.5608171535967394`, 1.056324582842535}}], 
          LineBox[{{4.130959373493924, 1.9939925918047017`}, {
           3.2705692600095193`, 1.4476862871532192`}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{3.2705692600095193`, 1.4476862871532192`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          LineBox[{{1.740347367311172, 3.0419214089378634`}, {
           2.048217304371548, 2.0790397033948085`}}], 
          LineBox[{{2.048217304371548, 2.0790397033948085`}, {
           2.5608171535967394`, 1.056324582842535}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.048217304371548, 2.0790397033948085`}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.38084977463297254`}, {0.9290981487070042, 
            0.7342210815652312}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.9565324864619495`, 1.291463008970201}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9290981487070042, 0.7342210815652312}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.5608171535967394`, 1.056324582842535}, {
            1.6961568721629507`, 0.6834434345517006}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.9565324864619495`, 1.291463008970201}, {
            1.6961568721629507`, 0.6834434345517006}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{4.356757411264541, 0.}, 0.03923814201810573], 
          DiskBox[{3.5776348824230384, 0.6308070829891423}, 
           0.03923814201810573], 
          DiskBox[{4.130959373493924, 1.9939925918047017}, 
           0.03923814201810573], 
          DiskBox[{3.2705692600095193, 1.4476862871532192}, 
           0.03923814201810573], 
          DiskBox[{1.740347367311172, 3.0419214089378634}, 
           0.03923814201810573], 
          DiskBox[{2.048217304371548, 2.0790397033948085}, 
           0.03923814201810573], 
          DiskBox[{0., 0.38084977463297254}, 0.03923814201810573], 
          DiskBox[{0.9290981487070042, 0.7342210815652312}, 
           0.03923814201810573], 
          DiskBox[{2.5608171535967394, 1.056324582842535}, 
           0.03923814201810573], 
          DiskBox[{1.9565324864619495, 1.291463008970201}, 
           0.03923814201810573], 
          DiskBox[{1.6961568721629507, 0.6834434345517006}, 
           0.03923814201810573]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 6, 3, 7, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 9}, {2, 10}, {4, 9}, {4, 
         11}, {6, 9}, {6, 11}, {8, 10}, {8, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[6, 9] -> ({Increment[$CellContext`x113$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x113$1992], 
               Line[#]]}& ), 
           UndirectedEdge[6, 11] -> ({
            Increment[$CellContext`x114$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x114$1992], 
               Line[#]]}& ), 
           UndirectedEdge[5, 10] -> ({
            Increment[$CellContext`x112$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x112$1992], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x110$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x110$1992], 
               Line[#]]}& ), 
           UndirectedEdge[2, 6] -> ({Increment[$CellContext`x108$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x108$1992], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x107$1992]; Append[
               Part[{{}}, $CellContext`x107$1992], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x115$1992]; Append[
               Part[{{}}, $CellContext`x115$1992], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({
            Increment[$CellContext`x117$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x117$1992], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({
            Increment[$CellContext`x116$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x116$1992], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({
            Increment[$CellContext`x118$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x118$1992], 
               Line[#]]}& ), 
           UndirectedEdge[3, 7] -> ({Increment[$CellContext`x109$1992]; Append[
               Part[{{}}, $CellContext`x109$1992], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x119$1992]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x119$1992], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x111$1992]; Append[
               Part[{{}}, $CellContext`x111$1992], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{0.9731396453097614, 3.4254729123358842`}, {
           1.3869520759036584`, 2.5184450914247343`}}], 
          LineBox[{{1.3869520759036584`, 2.5184450914247343`}, {
           2.2887770045855658`, 1.869041436854165}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{1.3869520759036584`, 2.5184450914247343`}, {
            1.0951501203736127`, 1.5844018059454523`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{3.8897117056192254`, 2.1258438546523903`}, {
            2.950875512867906, 1.7416843901425558`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.950875512867906, 1.7416843901425558`}, {
            2.2887770045855658`, 1.869041436854165}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{2.950875512867906, 1.7416843901425558`}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          LineBox[{{3.260766970993541, 0.}, {2.6561869353552154`, 
           0.8087340205925291}}], 
          LineBox[{{2.6561869353552154`, 0.8087340205925291}, {
           2.2887770045855658`, 1.869041436854165}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6561869353552154`, 0.8087340205925291}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.19393746063583683`}, {0.8071413616042142, 
            0.7726736823363426}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8071413616042142, 0.7726736823363426}, {
            1.0951501203736127`, 1.5844018059454523`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8071413616042142, 0.7726736823363426}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.0951501203736127`, 1.5844018059454523`}, {
            1.8675515163123033`, 1.1371573114482}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0.9731396453097614, 3.4254729123358842}, 
           0.03629716998937063], 
          DiskBox[{1.3869520759036584, 2.5184450914247343}, 
           0.03629716998937063], 
          DiskBox[{3.8897117056192254, 2.1258438546523903}, 
           0.03629716998937063], 
          DiskBox[{2.950875512867906, 1.7416843901425558}, 
           0.03629716998937063], 
          DiskBox[{3.260766970993541, 0.}, 0.03629716998937063], 
          DiskBox[{2.6561869353552154, 0.8087340205925291}, 
           0.03629716998937063], 
          DiskBox[{0., 0.19393746063583683}, 0.03629716998937063], 
          DiskBox[{0.8071413616042142, 0.7726736823363426}, 
           0.03629716998937063], 
          DiskBox[{2.2887770045855658, 1.869041436854165}, 
           0.03629716998937063], 
          DiskBox[{1.0951501203736127, 1.5844018059454523}, 
           0.03629716998937063], 
          DiskBox[{1.8675515163123033, 1.1371573114482}, 
           0.03629716998937063]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 5, 2, 7, 3, 6, 4, 8, 9, 10, 11}, {
        Null, {{1, 2}, {3, 4}, {5, 6}, {7, 8}, {2, 9}, {2, 10}, {6, 9}, {6, 
         11}, {4, 9}, {4, 11}, {8, 10}, {8, 11}, {10, 11}}}, {
        EdgeShapeFunction -> {
          UndirectedEdge[3, 6] -> ({Increment[$CellContext`x122$1995]; Append[
               Part[{{}}, $CellContext`x122$1995], 
               Line[#]]}& ), 
           UndirectedEdge[6, 9] -> ({Increment[$CellContext`x126$1995]; Append[
               Part[{{}}, $CellContext`x126$1995], 
               Line[#]]}& ), 
           UndirectedEdge[6, 11] -> ({
            Increment[$CellContext`x127$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x127$1995], 
               Line[#]]}& ), 
           UndirectedEdge[5, 10] -> ({
            Increment[$CellContext`x125$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x125$1995], 
               Line[#]]}& ), 
           UndirectedEdge[4, 8] -> ({Increment[$CellContext`x123$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x123$1995], 
               Line[#]]}& ), 
           UndirectedEdge[1, 5] -> ({Increment[$CellContext`x120$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x120$1995], 
               Line[#]]}& ), 
           UndirectedEdge[7, 9] -> ({Increment[$CellContext`x128$1995]; Append[
               Part[{{}}, $CellContext`x128$1995], 
               Line[#]]}& ), 
           UndirectedEdge[2, 7] -> ({Increment[$CellContext`x121$1995]; Append[
               Part[{{}}, $CellContext`x121$1995], 
               Line[#]]}& ), 
           UndirectedEdge[8, 10] -> ({
            Increment[$CellContext`x130$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x130$1995], 
               Line[#]]}& ), 
           UndirectedEdge[7, 11] -> ({
            Increment[$CellContext`x129$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x129$1995], 
               Line[#]]}& ), 
           UndirectedEdge[8, 11] -> ({
            Increment[$CellContext`x131$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x131$1995], 
               Line[#]]}& ), 
           UndirectedEdge[10, 11] -> ({
            Increment[$CellContext`x132$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x132$1995], 
               Line[#]]}& ), 
           UndirectedEdge[5, 9] -> ({Increment[$CellContext`x124$1995]; Append[
               Part[{{
                  Dashing[{Small, Small}]}}, $CellContext`x124$1995], 
               Line[#]]}& )}, ImageSize -> 300}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Dashing[{Small, Small}], 
           LineBox[{{0.9731396453097614, 3.4254729123358842`}, {
            1.3869520759036584`, 2.5184450914247343`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.3869520759036584`, 2.5184450914247343`}, {
            2.2887770045855658`, 1.869041436854165}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.3869520759036584`, 2.5184450914247343`}, {
            1.0951501203736127`, 1.5844018059454523`}}]}, 
          LineBox[{{3.8897117056192254`, 2.1258438546523903`}, {
           2.950875512867906, 1.7416843901425558`}}], 
          LineBox[{{2.950875512867906, 1.7416843901425558`}, {
           2.2887770045855658`, 1.869041436854165}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.950875512867906, 1.7416843901425558`}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          LineBox[{{3.260766970993541, 0.}, {2.6561869353552154`, 
           0.8087340205925291}}], 
          LineBox[{{2.6561869353552154`, 0.8087340205925291}, {
           2.2887770045855658`, 1.869041436854165}}], 
          {Dashing[{Small, Small}], 
           LineBox[{{2.6561869353552154`, 0.8087340205925291}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0., 0.19393746063583683`}, {0.8071413616042142, 
            0.7726736823363426}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8071413616042142, 0.7726736823363426}, {
            1.0951501203736127`, 1.5844018059454523`}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{0.8071413616042142, 0.7726736823363426}, {
            1.8675515163123033`, 1.1371573114482}}]}, 
          {Dashing[{Small, Small}], 
           LineBox[{{1.0951501203736127`, 1.5844018059454523`}, {
            1.8675515163123033`, 1.1371573114482}}]}}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[{0.9731396453097614, 3.4254729123358842}, 
           0.03629716998937063], 
          DiskBox[{1.3869520759036584, 2.5184450914247343}, 
           0.03629716998937063], 
          DiskBox[{3.8897117056192254, 2.1258438546523903}, 
           0.03629716998937063], 
          DiskBox[{2.950875512867906, 1.7416843901425558}, 
           0.03629716998937063], 
          DiskBox[{3.260766970993541, 0.}, 0.03629716998937063], 
          DiskBox[{2.6561869353552154, 0.8087340205925291}, 
           0.03629716998937063], 
          DiskBox[{0., 0.19393746063583683}, 0.03629716998937063], 
          DiskBox[{0.8071413616042142, 0.7726736823363426}, 
           0.03629716998937063], 
          DiskBox[{2.2887770045855658, 1.869041436854165}, 
           0.03629716998937063], 
          DiskBox[{1.0951501203736127, 1.5844018059454523}, 
           0.03629716998937063], 
          DiskBox[{1.8675515163123033, 1.1371573114482}, 
           0.03629716998937063]}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImageSize->300]}], "}"}]], "Output",
 CellChangeTimes->{3.739471781605933*^9, 3.739472016506028*^9, 
  3.7462720690090055`*^9, 3.7462722416225767`*^9, 3.762067536476658*^9, 
  3.76217366811707*^9},ExpressionUUID->"5c23a78e-d78c-47a6-b5c6-0543007dc63c"]
}, Open  ]]
},
WindowSize->{1536, 781},
WindowMargins->{{Automatic, 289}, {-1160, Automatic}},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Core.nb"]], 
   Cell[
    StyleData["MyStyle - H1"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 1, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[0.5, 0, 0.5], Background -> 
    RGBColor[0.94, 0.88, 0.94]], 
   Cell[
    StyleData["MyStyle - H1 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> 
    RGBColor[0.5, 0, 0.5], MenuSortingValue -> 2, FontFamily -> "Consolas", 
    FontSize -> 14, FontColor -> RGBColor[0.5, 0, 0.5], Background -> 
    RGBColor[0.94, 0.88, 0.94]], 
   Cell[
    StyleData["MyStyle - H2"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 3, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[1, 0.5, 0], Background -> RGBColor[1, 0.9, 0.8]], 
   Cell[
    StyleData["MyStyle - H2 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> RGBColor[1, 0.5, 0], 
    MenuSortingValue -> 4, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> RGBColor[1, 0.5, 0], Background -> RGBColor[1, 0.9, 0.8]], 
   Cell[
    StyleData["MyStyle - H3"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 5, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> GrayLevel[0.5], Background -> GrayLevel[0.9]], 
   Cell[
    StyleData["MyStyle - H3 Framed"], CellFrame -> {{0, 0}, {2, 2}}, 
    CellMargins -> {{66, 10}, {7, 7}}, CellFrameColor -> GrayLevel[0.5], 
    MenuSortingValue -> 6, FontFamily -> "Consolas", FontSize -> 14, 
    FontColor -> GrayLevel[0.5], Background -> GrayLevel[0.9]], 
   Cell[
    StyleData["MyStyle - Comments"], CellMargins -> {{66, 10}, {7, 7}}, 
    MenuSortingValue -> 7, FontFamily -> "Consolas", FontSize -> 12, 
    FontColor -> 
    RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255]], 
   Cell[
    StyleData[All, "Working"], $CellContext`CellInsertionPointCell -> 
    FEPrivate`FrontEndResource[
     "FEExpressions", 
      "CellInsertionMenu"], $CellContext`GhostCellInEmptyNotebook -> False], 
   Cell[
    StyleData[
    All, "SlideShow", StyleDefinitions -> StyleData[All, "Presentation"]], 
    PageWidth -> WindowWidth, DockedCells -> 
    FEPrivate`FrontEndResource["FEExpressions", "SlideshowToolbar"], 
    ScrollingOptions -> {
     "PagewiseDisplay" -> True, "VerticalScrollRange" -> Fit}, 
    ShowGroupOpener -> False, MenuSortingValue -> 1300], 
   Cell[
    StyleData[All, "Printout"], Magnification -> 0.72], 
   Cell[
    StyleData[
    All, "PrintoutGray", StyleDefinitions -> StyleData[All, "Printout"]], 
    MenuSortingValue -> 1500], 
   Cell[
    StyleData["Notebook"], PageHeaders -> {{
       Cell[
        TextData[{
          Cell[
           TextData[{
             CounterBox["Page"]}], "PageNumber"], "   ", 
          Cell[
          " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 
           4], 
          Cell[
           TextData[{
             ValueBox["FileName"]}], "Header"]}], 
        CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
       None}, {None, None, 
       Cell[
        TextData[{
          Cell[
           TextData[{
             ValueBox["FileName"]}], "Header"], 
          Cell[
          " ", "Header", CellFrame -> {{0, 0.5}, {0, 0}}, CellFrameMargins -> 
           4], "   ", 
          Cell[
           TextData[{
             CounterBox["Page"]}], "PageNumber"]}], 
        CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}}, 
    PageHeaderLines -> {False, False}, PageFooterLines -> {False, False}, 
    PrintingOptions -> {
     "FacingPages" -> True, "FirstPageFace" -> Right, "FirstPageFooter" -> 
      True, "FirstPageHeader" -> False}], 
   Cell[
    StyleData["Title"], CellMargins -> {{27, Inherited}, {10, 30}}, 
    StyleKeyMapping -> {"Tab" -> "Subtitle"}, 
    CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 4}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "Title", 
    CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}, {"Item", 0}, {"Subitem", 0}, {
      "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
      "SubsubitemNumbered", 0}}, MenuSortingValue -> 1100, MenuCommandKey -> 
    "1", FontFamily -> "Gill Sans", FontSize -> 44, FontColor -> 
    RGBColor[0.8, 0.043, 0.008]], 
   Cell[
    StyleData["Title", "Presentation"], 
    CellMargins -> {{67, Inherited}, {15, 45}}, LineSpacing -> {1, 18}, 
    FontSize -> 72], 
   Cell[
    StyleData["Title", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      15, 0.12 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 72], 
   Cell[
    StyleData["Title", "Condensed"], CellMargins -> {{18, 10}, {4, 8}}, 
    FontSize -> 20], 
   Cell[
    StyleData["Title", "Printout"], 
    CellMargins -> {{10, Inherited}, {10, 30}}], 
   Cell[
    StyleData["Title", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {10, 30}}, FontColor -> GrayLevel[0]], 
   Cell[
    StyleData["Subtitle"], CellMargins -> {{27, Inherited}, {20, 2}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubtitle", "Backspace" -> 
      "Title", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Title"}, 
    CellGroupingRules -> {"TitleGrouping", 10}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subtitle", 
    CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}, {"Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {
      "ItemNumbered", 0}, {"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, 
    MenuSortingValue -> 1150, MenuCommandKey -> "2", FontFamily -> 
    "Gill Sans", FontSize -> 24, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subtitle", "Presentation"], 
    CellMargins -> {{67, Inherited}, {30, 3}}, LineSpacing -> {1, 16}, 
    FontSize -> 48], 
   Cell[
    StyleData["Subtitle", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {30, 12}}, 
    LineSpacing -> {1, 2}, FontSize -> 48], 
   Cell[
    StyleData["Subtitle", "Condensed"], CellMargins -> {{18, 10}, {4, 4}}, 
    FontSize -> 14], 
   Cell[
    StyleData["Subtitle", "Printout"], 
    CellMargins -> {{10, Inherited}, {20, 2}}], 
   Cell[
    StyleData["Subtitle", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {20, 2}}], 
   Cell[
    StyleData["Subsubtitle"], CellMargins -> {{27, Inherited}, {8, 2}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subtitle", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Subtitle"}, 
    CellGroupingRules -> {"TitleGrouping", 20}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subsubtitle",
     CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1200, MenuCommandKey -> "3", FontFamily -> "Gill Sans", FontSize -> 16, 
    FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubtitle", "Presentation"], 
    CellMargins -> {{67, Inherited}, {12, 3}}, LineSpacing -> {1, 14}, 
    FontSize -> 32], 
   Cell[
    StyleData["Subsubtitle", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {12, 12}}, 
    LineSpacing -> {1, 2}, FontSize -> 32], 
   Cell[
    StyleData["Subsubtitle", "Condensed"], CellMargins -> {{18, 10}, {8, 8}}, 
    FontSize -> 12], 
   Cell[
    StyleData["Subsubtitle", "Printout"], 
    CellMargins -> {{10, Inherited}, {8, 2}}], 
   Cell[
    StyleData["Subsubtitle", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {8, 2}}], 
   Cell[
    StyleData["Section"], CellFrame -> {{0, 0}, {0, 1}}, 
    CellMargins -> {{27, Inherited}, {8, 34}}, 
    StyleKeyMapping -> {"Tab" -> "Subsection"}, 
    CellGroupingRules -> {"SectionGrouping", 30}, PageBreakBelow -> False, 
    CellFrameMargins -> 4, CellFrameColor -> GrayLevel[0.7], 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 2}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "Section", 
    CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
      "Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1250, MenuCommandKey -> "4", FontFamily -> "Gill Sans", FontSize -> 28, 
    FontColor -> 
    RGBColor[0.7612268253604944, 0.29576562142366675`, 0.08555733577477684]], 
   Cell[
    StyleData["Section", "Presentation"], CellFrame -> {{0, 0}, {0, 2}}, 
    CellMargins -> {{67, Inherited}, {12, 51}}, CellFrameMargins -> 8, 
    LineSpacing -> {1, 10}, FontSize -> 40], 
   Cell[
    StyleData["Section", "SlideShow"], 
    CellMargins -> {{
      0.06 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.04 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      12, 0.06 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 40], 
   Cell[
    StyleData["Section", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 12], 
   Cell[
    StyleData["Section", "Printout"], 
    CellMargins -> {{10, Inherited}, {8, 34}}], 
   Cell[
    StyleData["Section", "PrintoutGray"], 
    CellMargins -> {{10, Inherited}, {8, 34}}, FontColor -> GrayLevel[0.2]], 
   Cell[
    StyleData["Subsection"], CellMargins -> {{50.34765625, 3.}, {8., 12.}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsection", "Backspace" -> 
      "Section", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Section"}, 
    CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> False, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Subsection", 
    CounterAssignments -> {{"Subsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1300, MenuCommandKey -> "5", FontFamily -> "Gill Sans", FontSize -> 20, 
    FontColor -> 
    RGBColor[0.778286411841001, 0.4230563820859083, 0.16115053025101092`]], 
   Cell[
    StyleData["Subsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {12, 18}}, LineSpacing -> {1, 10}, 
    FontSize -> 28], 
   Cell[
    StyleData["Subsection", "SlideShow"], 
    CellMargins -> {{
      0.1 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.02 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      12, 0.046 FrontEnd`AbsoluteCurrentValue[{WindowSize, 2}]}}, 
    LineSpacing -> {1, 2}, FontSize -> 32], 
   Cell[
    StyleData["Subsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 11], 
   Cell[
    StyleData["Subsection", "Printout"], 
    CellMargins -> {{30, Inherited}, {8., 16}}], 
   Cell[
    StyleData["Subsection", "PrintoutGray"], 
    CellMargins -> {{30, Inherited}, {8., 16}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubsection"], CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsubsection", "Backspace" -> 
      "Subsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsection"}, CellGroupingRules -> {"SectionGrouping", 50}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsection", 
    CounterAssignments -> {{"Subsubsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1350, MenuCommandKey -> "6", FontFamily -> "Gill Sans", FontSize -> 19, 
    FontColor -> 
    RGBColor[0.7143816281376364, 0.21776150148775464`, 0.03341725795376516]], 
   Cell[
    StyleData["Subsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 6}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontSize -> 28], 
   Cell[
    StyleData["Subsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 11], 
   Cell[
    StyleData["Subsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 16}}], 
   Cell[
    StyleData["Subsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 16}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Subsubsubsection"], CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubsubsubsection", "Backspace" -> 
      "Subsubsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsubsection"}, CellGroupingRules -> {"SectionGrouping", 60}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsubsection", 
    CounterAssignments -> {{"Subsubsubsubsection", 0}, {"Item", 0}, {
      "Subitem", 0}, {"Subsubitem", 0}, {"ItemNumbered", 0}, {
      "SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    None, FontFamily -> "Arial", FontSize -> 14, FontWeight -> "Bold", 
    FontColor -> 
    RGBColor[0.778286411841001, 0.4230563820859083, 0.16115053025101092`]], 
   Cell[
    StyleData["Subsubsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 7}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontFamily -> "Arial", FontSize -> 22], 
   Cell[
    StyleData["Subsubsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 10], 
   Cell[
    StyleData["Subsubsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 14}}], 
   Cell[
    StyleData["Subsubsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 14}}, FontColor -> GrayLevel[0.4]], 
   Cell[
    StyleData["Subsubsubsubsection"], 
    CellMargins -> {{66, Inherited}, {2, 10}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subsubsubsection", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70}, 
    PageBreakBelow -> False, InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
    "Subsubsubsubsection", 
    CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {"Subsubitem", 0}, {
      "ItemNumbered", 0}, {"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}}, 
    MenuSortingValue -> None, FontFamily -> "Arial", FontSize -> 14, 
    FontColor -> RGBColor[0.5875944151979858, 0.053406576638437474`, 0.]], 
   Cell[
    StyleData["Subsubsubsubsection", "Presentation"], 
    CellMargins -> {{100, Inherited}, {3, 15}}, LineSpacing -> {1, 7}, 
    FontSize -> 24], 
   Cell[
    StyleData["Subsubsubsubsection", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {3, 15}}, 
    LineSpacing -> {1, 2}, FontSize -> 22], 
   Cell[
    StyleData["Subsubsubsubsection", "Condensed"], 
    CellMargins -> {{18, Inherited}, {6, 12}}, FontSize -> 10], 
   Cell[
    StyleData["Subsubsubsubsection", "Printout"], 
    CellMargins -> {{49, Inherited}, {6, 14}}], 
   Cell[
    StyleData["Subsubsubsubsection", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {6, 14}}, FontColor -> GrayLevel[0.3]], 
   Cell[
    StyleData["Text"], CellMargins -> {{66, 10}, {7, 7}}, 
    InputAutoReplacements -> {"TeX" -> FormBox[
        StyleBox[
         RowBox[{"T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "LaTeX" -> 
      FormBox[
        StyleBox[
         RowBox[{"L", 
           StyleBox[
            AdjustmentBox[
            "A", BoxMargins -> {{-0.5, -0.3}, {0, 0}}, 
             BoxBaselineShift -> -0.4], FontSize -> Smaller], "T", 
           AdjustmentBox[
           "E", BoxMargins -> {{-0.3, 0}, {0, 0}}, BoxBaselineShift -> 0.5], 
           "X"}], SingleLetterItalics -> False], TraditionalForm], "mma" -> 
      "Mathematica", "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
      "gridMathematica" -> FormBox[
        RowBox[{"grid", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica" -> FormBox[
        RowBox[{"web", 
          AdjustmentBox[
           StyleBox["Mathematica", FontSlant -> "Italic"], 
           BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], ParentList}, 
    LineSpacing -> {1, 3}, CounterIncrements -> "Text", MenuSortingValue -> 
    1400, MenuCommandKey -> "7", FontFamily -> "Arial", FontSize -> 14], 
   Cell[
    StyleData["Text", "Presentation"], CellMargins -> {{100, 10}, {10, 10}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["Text", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, FontSize -> 
    22], 
   Cell[
    StyleData["Text", "Condensed"], CellMargins -> {{18, 10}, {6, 6}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["Text", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["Text", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
    LineSpacing -> {1, 3}, LanguageCategory -> "NaturalLanguage", 
    CounterIncrements -> "SmallText", MenuSortingValue -> 1750, 
    StyleMenuListing -> None, FontFamily -> "Arial", FontSize -> 13, 
    FontColor -> GrayLevel[0.2]], 
   Cell[
    StyleData["SmallText", "Presentation"], 
    CellMargins -> {{100, 10}, {9, 9}}, LineSpacing -> {1, 5}, FontSize -> 
    18], 
   Cell[
    StyleData["SmallText", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {9, 9}}, FontSize -> 
    18], 
   Cell[
    StyleData["SmallText", "Condensed"], CellMargins -> {{18, 10}, {5, 5}}, 
    LineSpacing -> {1, 2}, FontSize -> 9], 
   Cell[
    StyleData["SmallText", "Printout"], 
    CellMargins -> {{33, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["SmallText", "PrintoutGray"], 
    CellMargins -> {{33, Inherited}, {Inherited, Inherited}}, Hyphenation -> 
    True], 
   Cell[
    StyleData["Item"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.8, 0.043, 0.008]], CellMargins -> {{81, 10}, {4, 8}}, 
    StyleKeyMapping -> {"Tab" -> "Subitem"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
    CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
    MenuSortingValue -> 1600, FontFamily -> "Arial", FontSize -> 
    14, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Item", "Presentation"], CellMargins -> {{140, 10}, {7, 7}}, 
    CellFrameLabelMargins -> 6, FontSize -> 24], 
   Cell[
    StyleData["Item", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Item", "Condensed"], CellMargins -> {{38, Inherited}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Item", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.2]], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Item", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.2]], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
    StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    DefaultNewCellStyle -> "Item", MenuSortingValue -> 1600, FontFamily -> 
    "Arial", FontSize -> 14, FontColor -> 
    GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["ItemParagraph", "Presentation"], 
    CellMargins -> {{140, 10}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["ItemParagraph", "SlideShow"], ShowGroupOpener -> False, 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["ItemParagraph", "Condensed"], 
    CellMargins -> {{38, Inherited}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["ItemParagraph", "Printout"], 
    CellMargins -> {{65, Inherited}, {Inherited, 0.5 Inherited}}], 
   Cell[
    StyleData["ItemParagraph", "PrintoutGray"], 
    CellMargins -> {{65, Inherited}, {Inherited, 0.5 Inherited}}], 
   Cell[
    StyleData["Subitem"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.8, 0.043, 0.008]], CellMargins -> {{105, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Tab" -> "Subsubitem", "Backspace" -> 
      "Item", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Item"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Item", 
    CounterIncrements -> "Subitem", CounterAssignments -> {{"Subsubitem", 0}},
     MenuSortingValue -> 1610, FontFamily -> "Arial", FontSize -> 
    13.5, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Subitem", "Presentation"], CellMargins -> {{176, 12}, {7, 7}}, 
    CellFrameLabelMargins -> 6, FontSize -> 24], 
   Cell[
    StyleData["Subitem", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Subitem", "Condensed"], CellMargins -> {{60, 2}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Subitem", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.3]], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Subitem", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.3]], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemParagraph"], CellMargins -> {{105, 12}, {4, 1}}, 
    StyleKeyMapping -> {
     "Tab" -> "SubsubitemParagraph", "Backspace" -> 
      "ItemParagraph", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "ItemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subitem", 
    MenuSortingValue -> 1610, FontFamily -> "Arial", FontSize -> 13.5, 
    FontColor -> GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubitemParagraph", "Presentation"], 
    CellMargins -> {{176, 12}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["SubitemParagraph", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["SubitemParagraph", "Condensed"], 
    CellMargins -> {{60, 2}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["SubitemParagraph", "Printout"], 
    CellMargins -> {{92, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["SubitemParagraph", "PrintoutGray"], 
    CellMargins -> {{92, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["Subsubitem"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "Subitem", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> "Subitem"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subsubitem", 
    CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, FontFamily -> 
    "Arial", FontSize -> 13, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["Subsubitem", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["Subsubitem", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 8, FontSize -> 22], 
   Cell[
    StyleData["Subsubitem", "Condensed"], CellMargins -> {{84, 2}, {2, 2}}, 
    FontSize -> 11], 
   Cell[
    StyleData["Subsubitem", "Printout"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.4]], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Subsubitem", "PrintoutGray"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.4]], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemParagraph"], CellMargins -> {{129, 12}, {4, 1}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "SubitemParagraph", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "SubitemParagraph"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Subsubitem", 
    CounterIncrements -> "Subsubitem", MenuSortingValue -> 1625, FontFamily -> 
    "Arial", FontSize -> 13, FontColor -> 
    GrayLevel[0.2], $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubsubitemParagraph", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 2}}, FontSize -> 24], 
   Cell[
    StyleData["SubsubitemParagraph", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 2}}, FontSize -> 
    22], 
   Cell[
    StyleData["SubsubitemParagraph", "Condensed"], 
    CellMargins -> {{84, 2}, {2, 1}}, FontSize -> 11], 
   Cell[
    StyleData["SubsubitemParagraph", "Printout"], 
    CellMargins -> {{119, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["SubsubitemParagraph", "PrintoutGray"], 
    CellMargins -> {{119, Inherited}, {Inherited, 0.1 Inherited}}], 
   Cell[
    StyleData["ItemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{81, 10}, {4, 8}}, 
    StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
    CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
    CounterAssignments -> {{"SubitemNumbered", 0}, {"SubsubitemNumbered", 0}},
     MenuSortingValue -> 1630, FontFamily -> "Arial", FontSize -> 
    15, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["ItemNumbered", "Presentation"], 
    CellMargins -> {{140, 10}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["ItemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["ItemNumbered", "Condensed"], 
    CellMargins -> {{38, Inherited}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["ItemNumbered", "Printout"], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["ItemNumbered", "PrintoutGray"], 
    CellMargins -> {{65, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{105, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Tab" -> "SubsubitemNumbered", "Backspace" -> 
      "ItemNumbered", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "ItemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "Item", 
    CounterIncrements -> "SubitemNumbered", 
    CounterAssignments -> {{"SubsubitemNumbered", 0}}, MenuSortingValue -> 
    1640, FontFamily -> "Arial", FontSize -> 
    13.5, $CellContext`ReturnCreatesNewCell -> True], 
   Cell[
    StyleData["SubitemNumbered", "Presentation"], 
    CellMargins -> {{176, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["SubitemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.155 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["SubitemNumbered", "Condensed"], 
    CellMargins -> {{60, 2}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["SubitemNumbered", "Printout"], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubitemNumbered", "PrintoutGray"], 
    CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], ".", 
        CounterBox["SubsubitemNumbered"], "."}], FontWeight -> "Bold"], 
    CellMargins -> {{129, 12}, {4, 4}}, 
    StyleKeyMapping -> {
     "Backspace" -> 
      "SubitemNumbered", $CellContext`KeyEvent[
       "Tab", $CellContext`Modifiers -> {$CellContext`Shift}] -> 
      "SubitemNumbered"}, 
    CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
    CellFrameLabelMargins -> 4, DefaultNewCellStyle -> "SubitemNumbered", 
    CounterIncrements -> "SubsubitemNumbered", MenuSortingValue -> 1645, 
    FontFamily -> "Arial", FontSize -> 13, $CellContext`ReturnCreatesNewCell -> 
    True], 
   Cell[
    StyleData["SubsubitemNumbered", "Presentation"], 
    CellMargins -> {{212, 12}, {7, 7}}, CellFrameLabelMargins -> 6, FontSize -> 
    24], 
   Cell[
    StyleData["SubsubitemNumbered", "SlideShow"], 
    CellMargins -> {{
      0.176 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, 
    CellFrameLabelMargins -> 6, FontSize -> 22], 
   Cell[
    StyleData["SubsubitemNumbered", "Condensed"], 
    CellMargins -> {{84, 2}, {2, 2}}, FontSize -> 11], 
   Cell[
    StyleData["SubsubitemNumbered", "Printout"], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SubsubitemNumbered", "PrintoutGray"], 
    CellMargins -> {{119, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SideCaptionArray", StyleDefinitions -> StyleData["Text"]], 
    GridBoxOptions -> {
     GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}}], 
   Cell[
    StyleData["SideCaptionArray", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["SideCaptionArray", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Input"], FontSize -> 13], 
   Cell[
    StyleData["Input", "Presentation"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["Input", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Input", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["Input", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, 8}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["Input", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, 8}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["InputOnly"], FontSize -> 13], 
   Cell[
    StyleData["InputOnly", "Presentation"], 
    CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["InputOnly", "SlideShow"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["InputOnly", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["InputOnly", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["InputOnly", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LinebreakAdjustments -> {0.85, 2, 10, 1, 1}], 
   Cell[
    StyleData["Code", "Presentation"], CellMargins -> {{100, 10}, {8, 15}}], 
   Cell[
    StyleData["Code", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Code", "Condensed"], CellMargins -> {{50, 10}, {2, 3}}], 
   Cell[
    StyleData["Code", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Code", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Output"], FontSize -> 13], 
   Cell[
    StyleData["Output", "Presentation"], CellMargins -> {{100, 10}, {15, 8}}], 
   Cell[
    StyleData["Output", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {15, 8}}, 
    LinebreakAdjustments -> {1, 2., 12., 1., 1.}, FontSize -> 20], 
   Cell[
    StyleData["Output", "Condensed"], 
    CellMargins -> {{50, Inherited}, {3, 2}}], 
   Cell[
    StyleData["Output", "Printout"], 
    CellMargins -> {{49, Inherited}, {9, 3}}], 
   Cell[
    StyleData["Output", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {9, 3}}], 
   Cell[
    StyleData["Message", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
   Cell[
    StyleData["Message", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, FontSize -> 
    18], 
   Cell[
    StyleData["Message", "Condensed"], 
    CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Message", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    CellFrameLabels -> {{None, None}, {None, None}}], 
   Cell[
    StyleData["Message", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
    GrayLevel[0.5]], 
   Cell[
    StyleData["Print"], 
    CellMargins -> {{66, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
   Cell[
    StyleData["Print", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, FontSize -> 
    18], 
   Cell[
    StyleData["Print", "Condensed"], 
    CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Print", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["InlineFormula"], 
    HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"}, 
    LanguageCategory -> "Formula", ScriptLevel -> 1, SingleLetterItalics -> 
    True, MenuSortingValue -> 1650, $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["InlineFormula", "Presentation"], 
    CellMargins -> {{10, 4}, {0, 12}}, LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["InlineFormula", "SlideShow"], FontSize -> 22], 
   Cell[
    StyleData["InlineFormula", "Condensed"], 
    CellMargins -> {{50, 10}, {6, 6}}, LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormula"], 
    CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
    DefaultFormatType -> DefaultInputFormatType, 
    HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"}, 
    LanguageCategory -> "Formula", ScriptLevel -> 0, SingleLetterItalics -> 
    True, MenuSortingValue -> 1700, FontFamily -> "Arial", FontSize -> 14, 
    FontColor -> GrayLevel[0.2], 
    UnderoverscriptBoxOptions -> {
     LimitsPositioning -> True}, $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["DisplayFormula", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["DisplayFormula", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      1.3 Inherited, 1.3 Inherited}}, FontSize -> 22], 
   Cell[
    StyleData["DisplayFormula", "Condensed"], 
    CellMargins -> {{50, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormula", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormula", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData[
    "DisplayFormulaNumbered", StyleDefinitions -> 
     StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
       Cell[
        TextData[{"(", 
          CounterBox["DisplayFormulaNumbered"], ")"}], 
        "DisplayFormulaEquationNumber"]}, {None, None}}, CounterIncrements -> 
    "DisplayFormulaNumbered", MenuSortingValue -> 1710], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Presentation"], 
    CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}, 
    LineSpacing -> {1, 5}, FontSize -> 24], 
   Cell[
    StyleData["DisplayFormulaNumbered", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {
      1.5 Inherited, 1.5 Inherited}}, FontSize -> 22], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Condensed"], 
    CellMargins -> {{50, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["DisplayFormulaNumbered", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormulaNumbered", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormulaEquationNumber"], FontFamily -> "Arial", 
    FontSize -> -1 + Inherited], 
   Cell[
    StyleData["Program"], CellFrame -> {{0, 0}, {0.5, 0.5}}, 
    CellMargins -> {{66, 10}, {8, 8}}, Hyphenation -> False, 
    AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
    LanguageCategory -> "Formula", ScriptLevel -> 1, MenuSortingValue -> 1800,
     FontFamily -> "Courier", $CellContext`StripStyleOnPaste -> True], 
   Cell[
    StyleData["Program", "Presentation"], CellFrame -> {{0, 0}, {1, 1}}, 
    CellMargins -> {{100, 4}, {0, 12}}, LineSpacing -> {1, 5}, FontSize -> 
    24], 
   Cell[
    StyleData["Program", "SlideShow"], CellFrame -> {{0, 0}, {1, 1}}, 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {12, 12}}, FontSize -> 
    22], 
   Cell[
    StyleData["Program", "Condensed"], CellMargins -> {{18, 10}, {6, 6}}, 
    LineSpacing -> {1, 1}, FontSize -> 11], 
   Cell[
    StyleData["Program", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Program", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Reference"], CellMargins -> {{66, 10}, {3, 3}}], 
   Cell[
    StyleData["Reference", "Presentation"], 
    CellMargins -> {{100, 10}, {5, 5}}], 
   Cell[
    StyleData["Reference", "SlideShow"], 
    CellMargins -> {{
      0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.03 
       FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {10, 10}}, FontSize -> 
    22], 
   Cell[
    StyleData["Reference", "Condensed"], CellMargins -> {{18, 10}, {3, 3}}], 
   Cell[
    StyleData["Reference", "Printout"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1., 2.}], 
   Cell[
    StyleData["Reference", "PrintoutGray"], 
    CellMargins -> {{49, Inherited}, {Inherited, Inherited}}, 
    LineSpacing -> {1., 2.}], 
   Cell[
    StyleData["Header"], CellMargins -> {{0, 0}, {0, 0}}, 
    LineSpacing -> {1, 8}, MenuSortingValue -> None, FontFamily -> "Verdana", 
    FontSize -> 7, FontSlant -> "Italic"], 
   Cell[
    StyleData["Header", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["Header", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSection"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderSection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSubsection"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderSubsection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderSubsection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderTitle"], StyleMenuListing -> None], 
   Cell[
    StyleData["HeaderTitle", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["HeaderTitle", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["Footer"], CellMargins -> {{0, 0}, {0, 0}}, MenuSortingValue -> 
    None, FontFamily -> "Verdana", FontSize -> 6], 
   Cell[
    StyleData["Footer", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["Footer", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSection"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterSection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSubsection"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterSubsection", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterSubsection", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["FooterTitle"], StyleMenuListing -> None], 
   Cell[
    StyleData["FooterTitle", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["FooterTitle", "PrintoutGray"], Magnification -> 1.], 
   Cell[
    StyleData["PageNumber"], LineSpacing -> {1, 8}, MenuSortingValue -> None, 
    FontFamily -> "Verdana", FontSize -> 7, FontWeight -> "Bold"], 
   Cell[
    StyleData["PageNumber", "Printout"], Magnification -> 1.], 
   Cell[
    StyleData["PageNumber", "PrintoutGray"], Magnification -> 1.]}, Visible -> 
  False, FrontEndVersion -> 
  "11.1 for Microsoft Windows (64-bit) (April 18, 2017)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 252, 4, 47, "MyStyle - H3", "ExpressionUUID" -> \
"48440d69-55fe-498e-9c8c-38c901e9aafb"],
Cell[813, 26, 208, 5, 30, "Input", "ExpressionUUID" -> \
"d21748be-f06a-4239-a8ec-fd8c77fd3cd1"],
Cell[1024, 33, 707, 14, 119, "MyStyle - H3", "ExpressionUUID" -> \
"73a88ba1-f430-42c3-bf87-0970f7e004c6"],
Cell[CellGroupData[{
Cell[1756, 51, 884, 18, 69, "Input", "ExpressionUUID" -> \
"a410d0bd-fb4a-4898-8eeb-e4a9c8290e99"],
Cell[2643, 71, 508, 11, 30, "Output", "ExpressionUUID" -> \
"1992921e-feef-4168-8632-db5d4f9b4b4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3188, 87, 479, 11, 50, "Input", "ExpressionUUID" -> \
"8a1ee9dd-3108-4a8b-a9c8-f700b260f862"],
Cell[3670, 100, 1315, 29, 179, "Output", "ExpressionUUID" -> \
"35207b7a-0c05-4eee-886a-1f96a2481949"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5022, 134, 1877, 44, 69, "Input", "ExpressionUUID" -> \
"e8823691-3b7b-4447-9ab6-eda9ce39006c"],
Cell[6902, 180, 4505, 152, 213, "Output", "ExpressionUUID" -> \
"b49d5f9a-db17-406d-a6f6-2ae214773003"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11444, 337, 479, 12, 50, "Input", "ExpressionUUID" -> \
"f119bf84-8f6e-49ba-9d55-883a441a781a"],
Cell[11926, 351, 24100, 419, 391, "Output", "ExpressionUUID" -> \
"38d18808-2c1c-4477-8ca9-67ed45f46bb4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36063, 775, 526, 12, 50, "Input", "ExpressionUUID" -> \
"1ff543ce-7bb8-454e-aa5e-a16e83956cd7"],
Cell[36592, 789, 61576, 1227, 878, "Output", "ExpressionUUID" -> \
"5c23a78e-d78c-47a6-b5c6-0543007dc63c"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

